(require "factor")
(unless (find-package "EULER")
	(make-package "EULER" :use '("XLISP" "FACTOR")))
(use-package "EULER")
(in-package "EULER")
(export '(euler1 euler2 euler3 euler4 euler5 euler6 euler7 euler8 euler9 euler10))

(defun euler1 (&aux (n 0))
       (dotimes (i 1000) 
		(when (or (zerop (mod i 5))(zerop (mod i 3)))
		      (incf n i)))
       n)

(defun euler2 ()
       (do ((n 2 (+ n nm1))
	    (nm1 1 n)
	    (sum 0))
	   ((> n 4000000) sum)
	   (when (evenp n) (incf sum n))))

(defun euler3 ()
       (apply #'max (factor 600851475143)))

(defun euler4 ( &aux (maxfound 0))
       (flet ((palindromep (val)
			   (let ((str (format nil "~s" val)))
				(equal str (reverse str)))))
	     (do ((v1 999 (1- v1)))
		 ((or (< v1 100) (< (* v1 v1) maxfound))
		  maxfound)
		 (do* ((v2 v1 (1- v2))
		       (product (* v1 v2)  (* v1 v2)))
		      ((or (< v2 100) (<= product maxfound)))
		      (when (palindromep product)
			    (setf maxfound product))))))

(defun euler5 ()
       (let ((v nil))
	    (dotimes (i 20) (push (1+ i) v))
	    (apply #'lcm v)))

(defun euler6 ()
       (flet ((iota (n &aux v)
		    (dotimes (i n) (push (1+ i) v))
		    v)
	      (sumsq (n)
		     (reduce #'+ (mapcar #'(lambda (x) (* x x)) n)))
	      (sqsum (n)
		     (expt (reduce #'+ n) 2)))
	     (let ((n (iota 100)))
		  (abs (- (sumsq n) (sqsum n))))))

(defun euler7 ()
       (progn
	(do () ((> (length *primes*) 10000)) (factor::addprime))
	(nth 10000 *primes*)))


(defun euler8 ()
(apply #'max 
       (maplist #'(lambda (x) (if (> (length x) 5)
				  (* (car x) (cadr x) (caddr x) (cadddr x) (fifth x))
				  0))
		(map 'list #'digit-char-p 
		     (strcat
		      "73167176531330624919225119674426574742355349194934"
		      "96983520312774506326239578318016984801869478851843"
		      "85861560789112949495459501737958331952853208805511"
		      "12540698747158523863050715693290963295227443043557"
		      "66896648950445244523161731856403098711121722383113"
		      "62229893423380308135336276614282806444486645238749"
		      "30358907296290491560440772390713810515859307960866"
		      "70172427121883998797908792274921901699720888093776"
		      "65727333001053367881220235421809751254540594752243"
		      "52584907711670556013604839586446706324415722155397"
		      "53697817977846174064955149290862569321978468622482"
		      "83972241375657056057490261407972968652414535100474"
		      "82166370484403199890008895243450658541227588666881"
		      "16427171479924442928230863465674813919123162824586"
		      "17866458359124566529476545682848912883142607690042"
		      "24219022671055626321111109370544217506941658960408"
		      "07198403850962455444362981230987879927244284909188"
		      "84580156166097919133875499200524063689912560717606"
		      "05886116467109405077541002256983155200055935729725"
		      "71636269561882670428252483600823257530420752963450")))))

(defun euler9 ()
       (let ((squares (let (x)
			   (dotimes (i 500) (push (* i i) x))
			   (reverse (coerce x 'array)))))
	    (do ((c 500 (1- c))) ; hypotenuse can't be greater than 500
		() ; since a solution is known to exist, no termination test needed
		(do* ((b (floor (- 1000 c) 2) (1- b)) ; second side to half of remainder
		      (arequired (- 1000 c b) (- 1000 c b))
		      (csq (* c c)))
		     ((< b 1)) ; b must be greater than zero
		     (when (eql csq (+ (* b b) (* arequired arequired)))
			   (return-from euler9 (list arequired b c (* arequired b c))))
		     ))))

(defun euler10 ( &aux (sum 0))
       (do ((prime 2 (nextprime prime)))
	   ((> prime 2000000))
	   (setq sum (+ prime sum)))
       sum)

(in-package "USER")
