; Test of the loop feature
(when (find-package '#:loop-test) (delete-package '#:loop-test))
(make-package '#:loop-test :use '(#:xlisp))
(in-package #:loop-test)

(setq i 7)
(defun te (exp act) (if (equal exp act)
                        (format t "passed\n")
                        (format t "* expected ~s \n* actual ~s\n" exp act)))

(te 7 (loop with i = i return i))
(setq i 7)
(te '(1 . 2) (loop with i = 1 with j = (1+ i) return (cons i j)))
(setq i 7)
(te '(1 . 8) (loop with i = 1 and j = (1+ i) return (cons i j)))
(te '(a b c) (loop with i = '(c b a) with j = nil while i do (push (car i) j) (setq i (cdr i)) finally return j))
(te '(a b c d) (loop with (p q r s) = '(a b c d) return (list p q r s)))
(te '(a b c d) (loop with ((p q) (r s)) = '((a b) (c d)) return (list p q r s)))
(te '(a (b c d)) (loop with (p . q) = '(a b c d) return (list p q)))
(setq i '(a b c))
(te '(b (c) a (b c)) (loop with (i . q) = (cdr i) and (r . s) = i return (list i q r s)))
(setq i '(a b c))
(te '(a (b c) b (c)) (loop with (i . q) = i with (r . s) = q return (list i q r s)))
(te '(a b c) (loop for i in '(c b a) with j do (push i j) finally return j))
(te '(a b c) (loop for i in '(a x b x c x) by #'cddr collect i)) 
(te '(a b c) (loop for i in '(a b c) by (lambda (x) (cdr x)) collect i))
(te '((1 a) (2 b) (3 c)) (loop for (a b) in '((a 1) (b 2) (c 3)) collect (list b a)))
(te '((1 a) (3 c)) (loop for (a b) in '((a 1) (b 2) (c 3)) by #'cddr collect (list b a)))    
(te '(a b c) (loop for i on '(c b a) with j do (push (car i) j) finally return j))
(te '(a b c) (loop for i on '(a x b x c x) by #'cddr collect (car i))) 
(te '(a b c) (loop for i on '(a b c) by (lambda (x) (cdr x)) collect (car i)))
(te '((p (q r s t)) (q (r s t)) (r (s t)) (s (t)) (t nil))
    (loop for (a . b) on '(p q r s t) collect (list a b)))
(te '((p (q r s t)) (r (s t)) (t nil))
    (loop for (a . b) on '(p q r s t) by #'cddr collect (list a b)))
(setq i 5)
(te '(1 2 3 4 5) (loop for i from 1 to i collect i))
(te '(1 2 3 4 5) (loop for i to 4 collect (1+ i)))
(te '(1 2 3 4 5) (loop for i from 1 to 5 collect i))
(te '(1 2 3 4 5) (loop as i from 1 to 5 collect i))
(te '(5 4 3 2 1) (loop for i downfrom 5 to 1 collect i))
(te '(5 3 1) (loop for i by 2 downfrom 5 to 1 collect i))
(te '(1 2 3 4 5) (loop for i from 1 below 6 collect i))
(te '(5 4 3 2 1) (loop for i from 5 above 0 collect i))
(te '(1 2 3 4 5 6) (loop for i from 1 to 5 by 2 collect i collect (1+ i)))
(te '(a a a a a) (loop repeat 5 collect 'a))
(te '(a a a a a) (loop for i = 'a repeat 5 collect i do (setq i nil)))
(te '(a b c d e) (loop for i = '(a b c d e) then (cdr i) while i collect (car i)))
(te '(((a 1) (b 2)) ((a 1) (b 2))) (loop repeat 2 as (a b) = '((a 1) (b 2)) collect (list a b)))
(te '(((a 1) (b 2)) ((c 3) (d 4))) (loop repeat 2 as (a b) = '((a 1) (b 2)) then '((c 3)(d 4)) collect (list a b)))
(te '(a b c d e) (loop for i across #(a b c d e) collect i))
(te '(a b c d e) (loop for i in '(a b c d e) collect i into x finally return x))
(te '(a b c d e) (loop for i in '(a b c d e) append (list i)))
(te '(z a b c d e) (loop for i in '(a b c d e) append (list i) into x finally do (setq x (cons 'z x)) return x))
(te '(a b c b c c) (loop for i on '(a b c) append i))
(te '(a b c b c c) (loop for i on '(a b c) append i into x finally return x))
(te '(a b c d e) (loop for i in '(a b c d e) nconc (list i)))
(te '(a b c d e) (loop for i in '(a b c d e) nconc (list i) into x finally return x))
(te 15 (loop for i from 1 to 5 sum i))
(te 15 (loop for i from 1 to 5 sum i into n finally return n))
(te 15 (loop finally return n for i from 1 to 5 sum i into n))
(te 2 (loop for i from 1 to 5 count (evenp i)))
(te 2 (loop for i from 1 to 5 count (evenp i) into n finally return n))
(te 5 (loop for i in '(3 4 5 1 2) maximize i))
(te 5 (loop for i in '(3 4 5 1 2) maximize i into n finally return n))
(te 1 (loop for i in '(3 4 5 1 2) minimize i))
(te 1 (loop for i in '(3 4 5 1 2) minimize i into n finally return n))
(te '(1 2 3 4 5) (loop for i from 1 collect i until (> i 4)))
(te t (loop for i from 1 to 5 always (< i 6)))
(te nil (loop for i from 1 to 5 always (not (eql i 3))))
(te t (loop for i from 1 to 5 never (eql i 6)))
(te nil (loop for i from 1 to 5 never (eql i 3)))
(te '(a . b) (loop for i in '(a b c) thereis (assoc i '((a . b) (d . e) (e . f)))))
(te nil (loop for i in '(b c f) thereis (assoc i '((a . b) (d . e) (e . f)))))

(te '((1 3 5)(2 4)) (loop for i from 1 to 5 if (oddp i) collect i into x else collect i into y finally return (list x y)))
(te '((1 3 5)(2 4)) (loop for i from 1 to 5 when (oddp i) collect i into x else collect i into y finally return (list x y)))
(te '((1 3 5)(2 4)) (loop for i from 1 to 5 unless (evenp i) collect i into x else collect i into y finally return (list x y)))
(te '((1 3 5)(1 3 5)(2 4)(2 4))
    (loop for i from 1 to 5
          if (oddp i)
            collect i into x and append (list i) into y
          else
            collect i into z and append (list i) into zz
          end
          finally return (list x y z zz)))

(te '(a b c d e) (loop with i while i collect (car i) do (setq i (cdr i)) initially (setq i '(a b c d e))))
(te '(a b c d e) (loop for i in (loop for i in '(a b c d e) collect i) collect i))

(te 'done (loop named foo for i in '(a b c) collect i do (loop named bar do (return-from foo 'done))))
(te '(a b c) (loop named foo for i in '(a b c) collect i do (loop named bar do (return-from bar 'done))))

(te '((a . b) (d . e) (e . f)) (loop for i in '(a b c d e) when (assoc i '((a . b)(d . e)(e . f))) collect it))

(te '(a . b) (loop for i in '(a b c d e) when (assoc i '((a . b)(d . e)(e . f))) return it))

(te '(a b c) (loop with i = '(a b c) collect (car i) do (unless (setq i (cdr i)) (loop-finish))))

(setq a (make-hash-table))
(setf (gethash '1 a) 7)
(setf (gethash '2 a) 8)
(setf (gethash '3 a) 9)
(te '(1 2 3) (loop for i being the hash-keys of a collect i into x finally return (sort x #'<)))
(te '(7 8 9) (loop for i being the hash-values of a collect i into x finally return (sort x #'<)))
(te '((1 7)(2 8)(3 9)) (loop for i being the hash-keys of a using (hash-values j) collect (list i j) into x finally return
                             (sort x #'(lambda (x y) (< (car x) (car y))))))
(te '((1 7)(2 8)(3 9)) (loop for i being the hash-values of a using (hash-keys j) collect (list j i) into x finally return
                             (sort x #'(lambda (x y) (< (car x) (car y))))))

(when (find-package '#:foobar) (delete-package '#:foobar))
(when (find-package '#:barfoo) (delete-package '#:barfoo))
(make-package '#:barfoo)
(setq barfoo::abc nil)
(export 'barfoo::abc '#:barfoo)
(make-package '#:foobar :use '(#:barfoo))
(setq foobar::foo1 nil foobar::foo2 nil foobar::foo3 nil)
(export 'foobar::foo1 '#:foobar)
(te '(foobar::foo2 foobar::foo3)
    (loop for i being the present-symbols in '#:foobar collect i into x
          finally return (sort x #'(lambda (x y) (string< (symbol-name x) (symbol-name y))))))
(te '(foobar:foo1)
    (loop for i being the external-symbols in '#:foobar collect i into x
          finally return (sort x #'(lambda (x y) (string< (symbol-name x) (symbol-name y))))))             
(te  '(barfoo::abc foobar::foo1 foobar::foo2 foobar::foo3)
     (loop for i being the symbols in '#:foobar collect i into x
           finally return (sort x #'(lambda (x y) (string< (symbol-name x) (symbol-name y))))))

(delete-package '#:foobar)
(delete-package '#:barfoo)

(in-package "USER")
(delete-package '#:loop-test)
