/* reads from standard input, removing tabs from file */
#include <stdio.h>
#include <math.h>

usage()

{
	fprintf(stderr,"usage:\nuntab [tabsize] <source >dest\n");
	exit(4);
}


main(argc,argv)
int argc;
char *argv[];
{
	int pos=0;
	int c;
	int tabsize=8;
	int count;

	if (argc>2) usage();
	if (argc==2) {
		tabsize = abs(atoi(argv[1]));
		if (tabsize == 0) usage();
	}
	
	while ((c = getchar()) != EOF) {
		switch (c) {
			case '\n':
				pos = 0;
				putchar('\n');
				break;
			case '\t':
				pos += (count=tabsize - (pos % tabsize));
				while (count--) putchar(' ');
				break;
			default:
				putchar(c);
				pos++;
				break;
		}
	}
}

