/* reads from standard input, inserting tabs into file were posible */
#include <stdio.h>
#include <math.h>

int blanks=-1;
int pos=0;
int c;
int tabsize=8;

setpos()
{
	if (blanks != -1) {
		if(pos == blanks+1) {	/* dont convert single space */
			putchar(' ');
			blanks = -1;
			return;
		}
		while ((pos/tabsize) > (blanks/tabsize)) {
			putchar('\t');
			blanks += tabsize - (blanks % tabsize);
		}
		while (pos > blanks) {
			putchar(' ');
			blanks++;
		}
		blanks = -1;
	}
}
			

usage()

{
	fprintf(stderr,"usage:\nentab [tabsize] <source >dest\n");
	exit(4);
}


main(argc,argv)
int argc;
char *argv[];
{
	if (argc>2) usage();
	if (argc==2) {
		tabsize = abs(atoi(argv[1]));
		if (tabsize == 0) usage();
	}
	
	while ((c = getchar()) != EOF) {

		switch (c) {
			case ' ':
				if (blanks == -1) blanks = pos;
				pos++;
				break;
			case '\n':
				pos = 0;
				blanks = -1;
				putchar('\n');
				break;
			case '\t':
				setpos();
				putchar('\t');
				pos += tabsize - (pos % tabsize);
				break;
			default:
				setpos();
				putchar(c);
				pos++;
				break;
		}
	}
}

