/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import sudoku.Chooser;
import sudoku.Field;
import sudoku.MultipleSolutionException;
import sudoku.PlayEngine;
import sudoku.ViewScreen;

public class PlayPanel
extends JPanel {
    private Field _f = new Field();
    private JButton jButtonClear;
    private JButton jButtonCreate;
    private JButton jButtonDifficult;
    private JButton jButtonPlay;
    private JButton jButtonPlayNoRetry;
    private JButton jButtonValidate;
    private JLabel jLabelStatus;
    private JPanel jPanel1;
    private JToggleButton jToggleButtonHints;
    private JToggleButton jToggleButtonLocked;
    private ViewScreen viewScreen;

    public PlayPanel() {
        this._f.calculatePossibles();
        this.initComponents();
    }

    private void initComponents() {
        this.viewScreen = new ViewScreen();
        this.jPanel1 = new JPanel();
        this.jButtonClear = new JButton();
        this.jToggleButtonLocked = new JToggleButton();
        this.jButtonPlayNoRetry = new JButton();
        this.jButtonPlay = new JButton();
        this.jButtonValidate = new JButton();
        this.jButtonCreate = new JButton();
        this.jButtonDifficult = new JButton();
        this.jToggleButtonHints = new JToggleButton();
        this.jLabelStatus = new JLabel();
        this.setLayout(new BorderLayout());
        this.viewScreen.setBackground(Color.white);
        this.viewScreen.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                PlayPanel.this.viewScreenKeyTyped(evt);
            }
        });
        this.add((Component)this.viewScreen, "Center");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonClear.setText("Clear");
        this.jButtonClear.setToolTipText("Clear puzzle field");
        this.jButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jButtonClearActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jButtonClear, gridBagConstraints);
        this.jToggleButtonLocked.setText("Lock");
        this.jToggleButtonLocked.setToolTipText("lock/unlock current values as hints");
        this.jToggleButtonLocked.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jToggleButtonLockedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jToggleButtonLocked, gridBagConstraints);
        this.jButtonPlayNoRetry.setText("Play forced");
        this.jButtonPlayNoRetry.setToolTipText("Fill in locations with values that are forced");
        this.jButtonPlayNoRetry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jButtonPlayNoRetryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jButtonPlayNoRetry, gridBagConstraints);
        this.jButtonPlay.setText("Solve");
        this.jButtonPlay.setToolTipText("Exhaustive search for solution");
        this.jButtonPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jButtonPlayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jButtonPlay, gridBagConstraints);
        this.jButtonValidate.setText("Validate");
        this.jButtonValidate.setToolTipText("Is puzzle solvable?");
        this.jButtonValidate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jButtonValidateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jButtonValidate, gridBagConstraints);
        this.jButtonCreate.setText("Create puzzle");
        this.jButtonCreate.setToolTipText("Easy puzzle solvable by forced values only");
        this.jButtonCreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jButtonCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jButtonCreate, gridBagConstraints);
        this.jButtonDifficult.setText("Hard Puzzle");
        this.jButtonDifficult.setToolTipText("Unique solution that will require guessing");
        this.jButtonDifficult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jButtonDifficultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.jButtonDifficult, gridBagConstraints);
        this.jToggleButtonHints.setText("Hints");
        this.jToggleButtonHints.setToolTipText("Turns on/off hints");
        this.jToggleButtonHints.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PlayPanel.this.jToggleButtonHintsActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jToggleButtonHints, new GridBagConstraints());
        this.add((Component)this.jPanel1, "After");
        this.jLabelStatus.setText("Sudoku Game -- click on location, type 1 through 9 or space to clear");
        this.add((Component)this.jLabelStatus, "Last");
    }

    private void jToggleButtonLockedActionPerformed(ActionEvent evt) {
        this._f.lockArray(this.jToggleButtonLocked.isSelected());
        this.viewScreen.drawAll(this._f);
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this._f = new Field();
        this._f.calculatePossibles();
        this.jToggleButtonLocked.setSelected(false);
        this.viewScreen.drawAll(this._f);
    }

    private void viewScreenKeyTyped(KeyEvent evt) {
        char key = evt.getKeyChar();
        evt.consume();
        Point pt = this.viewScreen.getLogCursorPosition();
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        int index = Field.coordinatesToIndex(x, y);
        if (!this._f.isLocked(index)) {
            if (key == ' ') {
                this._f.squares[index] = 0;
            } else if (key >= '0' && key <= '9') {
                int val = key - 48;
                int saveSquare = this._f.squares[index];
                this._f.squares[index] = 0;
                this._f.setMarks();
                this._f.calculatePossibles();
                if ((this._f.possibles[index] & 1 << val - 1) == 0) {
                    this._f.squares[index] = saveSquare;
                    this._f.setMarks();
                    this._f.calculatePossibles();
                    this.getToolkit().beep();
                    return;
                }
                this._f.squares[index] = val;
            } else {
                this.getToolkit().beep();
                return;
            }
            this.viewScreen.putText(x, y, this._f);
            this._f.setMarks();
            int state = this._f.getState();
            switch (state) {
                case 1: {
                    this.jLabelStatus.setText("FAIL: no available moves");
                    break;
                }
                case 0: {
                    this.jLabelStatus.setText("SUCCESS!!!");
                    break;
                }
                case 2: {
                    this.jLabelStatus.setText("Puzzle in progress");
                }
            }
        }
        int times = 0;
        while (times++ <= 81) {
            if (x < 8) {
                ++x;
            } else {
                x = 0;
                y = y < 8 ? ++y : 0;
            }
            if (this._f.isLocked(Field.coordinatesToIndex(x, y))) continue;
        }
        this.viewScreen.setLogCursorPosition(x, y);
        if (this.jToggleButtonHints.isSelected()) {
            this.viewScreen.drawAll(this._f);
        }
    }

    private void jButtonPlayActionPerformed(ActionEvent evt) {
        Field new_f = new Field(this._f);
        if (!this.jToggleButtonLocked.isSelected()) {
            new_f.lockArray(true);
        }
        PlayEngine p = new PlayEngine(new_f);
        try {
            new_f = p.playUntilSolvedOrQuit();
        }
        catch (MultipleSolutionException ex) {
            // empty catch block
        }
        if (new_f == null) {
            this.jLabelStatus.setText("No solution found");
        } else {
            this.jToggleButtonLocked.setSelected(true);
            this.jLabelStatus.setText("Computer Solution Found!!");
            this._f = new_f;
            this.viewScreen.drawAll(this._f);
        }
    }

    private void jButtonPlayNoRetryActionPerformed(ActionEvent evt) {
        Field new_f = new Field(this._f);
        if (!this.jToggleButtonLocked.isSelected()) {
            new_f.lockArray(true);
        }
        PlayEngine p = new PlayEngine(new_f);
        p.setNoBacktrack();
        try {
            new_f = p.playUntilSolvedOrQuit();
        }
        catch (MultipleSolutionException ex) {
            // empty catch block
        }
        if (new_f == null) {
            this.jLabelStatus.setText("No solution possible");
        } else {
            int state = new_f.getState();
            switch (state) {
                case 1: {
                    this.jLabelStatus.setText("FAIL: no available moves");
                    return;
                }
                case 0: {
                    this.jLabelStatus.setText("Computer solution found!!!");
                    break;
                }
                case 2: {
                    this.jLabelStatus.setText("Puzzle in progress");
                }
            }
            this.jToggleButtonLocked.setSelected(true);
            this._f = new_f;
            this.viewScreen.drawAll(this._f);
        }
    }

    private void jButtonValidateActionPerformed(ActionEvent evt) {
        switch (PlayEngine.verify(this._f)) {
            case 0: {
                this.jLabelStatus.setText("No solution possible");
                break;
            }
            case 1: {
                this.jLabelStatus.setText("Easy solution possible");
                break;
            }
            case 2: {
                this.jLabelStatus.setText("Hard solution possible");
            }
        }
    }

    private void createEasyPuzzle() {
        this._f = new Field();
        this._f.calculatePossibles();
        PlayEngine p = new PlayEngine(this._f);
        this._f = p.playRandomlyUntilSolvedOrQuit();
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < 81; ++i) {
            l.add(i);
        }
        Collections.shuffle(l, Chooser.getChooser().getRandom());
        Iterator i$ = l.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            Field new_f = new Field(this._f);
            new_f.squares[i] = 0;
            new_f.setMarks();
            p = new PlayEngine(new_f);
            p.setNoBacktrack();
            try {
                new_f = p.playUntilSolvedOrQuit();
            }
            catch (MultipleSolutionException ex) {
                // empty catch block
            }
            if (new_f.getState() != 0) continue;
            this._f.squares[i] = 0;
            this._f.setMarks();
        }
        this._f.calculatePossibles();
    }

    private void jButtonCreateActionPerformed(ActionEvent evt) {
        this.createEasyPuzzle();
        this.jToggleButtonLocked.setSelected(true);
        this._f.lockArray(true);
        this.viewScreen.drawAll(this._f);
        this.jLabelStatus.setText("Easy puzzle created, " + this._f.hints() + " hints.");
    }

    private void jButtonDifficultActionPerformed(ActionEvent evt) {
        this.createEasyPuzzle();
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int i = 0; i < 81; ++i) {
            if (this._f.squares[i] == 0) continue;
            l.add(i);
        }
        Collections.shuffle(l, Chooser.getChooser().getRandom());
        Iterator i$ = l.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            Field new_f = new Field(this._f);
            new_f.squares[i] = 0;
            new_f.setMarks();
            PlayEngine p = new PlayEngine(new_f);
            p.setCheckMultiples(true);
            try {
                new_f = p.playUntilSolvedOrQuit();
                if (new_f == null) continue;
                this._f.squares[i] = 0;
                this._f.setMarks();
            }
            catch (MultipleSolutionException ex) {}
        }
        this.jToggleButtonLocked.setSelected(true);
        this._f.lockArray(true);
        this.viewScreen.drawAll(this._f);
        this.jLabelStatus.setText("Hard but unique puzzle created, " + this._f.hints() + " hints.");
    }

    private void jToggleButtonHintsActionPerformed(ActionEvent evt) {
        this.viewScreen.setHinting(this.jToggleButtonHints.isSelected());
        this.viewScreen.drawAll(this._f);
        if (this.jToggleButtonHints.isSelected()) {
            this.jLabelStatus.setText("Green: one choice, Yellow: two choices");
        }
    }
}

