/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

public class Field {
    public int[] possibles;
    public int[] possiblesCount;
    public int[] squares;
    private boolean[] _locked = new boolean[81];
    private int[] _hintValue = new int[81];
    private int[] _columnMarks;
    private int[] _rowMarks;
    private int[] _quadrantMarks;
    private static final String[] _sqvals = new String[]{"- ", "1 ", "2 ", "3 ", "4 ", "5 ", "6 ", "7 ", "8 ", "9 "};
    public static final int SUCCESS = 0;
    public static final int FAIL = 1;
    public static final int IN_PROGRESS = 2;
    public static final int NO_HINT = 0;
    public static final int ONE_HINT = 1;
    public static final int TWO_HINT = 2;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int row = 0; row < 9; ++row) {
            for (int col = 0; col < 9; ++col) {
                sb.append(_sqvals[this.squares[Field.coordinatesToIndex(col, row)]]);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public int hints() {
        int count = 0;
        for (int i = 0; i < 81; ++i) {
            if (this.squares[i] == 0) continue;
            ++count;
        }
        return count;
    }

    public Field() {
        this.squares = new int[81];
        this.possibles = new int[81];
        this.possiblesCount = new int[81];
        this._columnMarks = new int[9];
        this._rowMarks = new int[9];
        this._quadrantMarks = new int[9];
    }

    public Field(Field f) {
        this();
        System.arraycopy(f.squares, 0, this.squares, 0, 81);
        System.arraycopy(f._hintValue, 0, this._hintValue, 0, 81);
        System.arraycopy(f._locked, 0, this._locked, 0, 81);
        System.arraycopy(f.possibles, 0, this.possibles, 0, 81);
        System.arraycopy(f.possiblesCount, 0, this.possiblesCount, 0, 81);
        System.arraycopy(f._columnMarks, 0, this._columnMarks, 0, 9);
        System.arraycopy(f._rowMarks, 0, this._rowMarks, 0, 9);
        System.arraycopy(f._quadrantMarks, 0, this._quadrantMarks, 0, 9);
    }

    public static int indexToRow(int index) {
        return index / 9;
    }

    public static int indexToColumn(int index) {
        return index % 9;
    }

    public static int indexToQuadrant(int index) {
        return Field.indexToColumn(index) / 3 * 3 + Field.indexToRow(index) / 3;
    }

    public static int coordinatesToIndex(int x, int y) {
        return y * 9 + x;
    }

    public void fillAt(int index, int value) {
        this.squares[index] = value;
        int mask = 1 << value - 1;
        int n = Field.indexToColumn(index);
        this._columnMarks[n] = this._columnMarks[n] | mask;
        int n2 = Field.indexToRow(index);
        this._rowMarks[n2] = this._rowMarks[n2] | mask;
        int n3 = Field.indexToQuadrant(index);
        this._quadrantMarks[n3] = this._quadrantMarks[n3] | mask;
    }

    public void setMarks() {
        this._columnMarks = new int[9];
        this._rowMarks = new int[9];
        this._quadrantMarks = new int[9];
        for (int i = 0; i < 81; ++i) {
            this.fillAt(i, this.squares[i]);
        }
    }

    public void lockArray(boolean flag) {
        if (flag) {
            for (int i = 0; i < 81; ++i) {
                this._locked[i] = this.squares[i] != 0;
            }
        } else {
            for (int i = 0; i < 81; ++i) {
                this._locked[i] = false;
            }
        }
    }

    public void calculatePossibles() {
        int i;
        int maxPossible = 10;
        for (i = 0; i < 81; ++i) {
            int possible;
            if (this.squares[i] != 0) {
                this.possibles[i] = 0;
                this.possiblesCount[i] = 0;
                continue;
            }
            int row = Field.indexToRow(i);
            int col = Field.indexToColumn(i);
            int quad = Field.indexToQuadrant(i);
            int count = 0;
            this.possibles[i] = possible;
            for (possible = 0x1FF & ((this._columnMarks[col] | this._rowMarks[row] | this._quadrantMarks[quad]) ^ 0xFFFFFFFF); possible != 0; possible >>= 1) {
                count += possible & 1;
            }
            this.possiblesCount[i] = count;
            if (count <= 0 || count >= maxPossible) continue;
            maxPossible = count;
        }
        if (maxPossible == 1 || maxPossible == 2) {
            int val = maxPossible == 2 ? 2 : 1;
            for (int i2 = 0; i2 < 81; ++i2) {
                this._hintValue[i2] = this.squares[i2] == 0 && this.possiblesCount[i2] == maxPossible ? val : 0;
            }
        } else {
            for (i = 0; i < 81; ++i) {
                this._hintValue[i] = 0;
            }
        }
    }

    public int getState() {
        this.calculatePossibles();
        int bestPos = 0;
        int bestVal = 10;
        int bestCount = 0;
        for (int i = 0; i < 81; ++i) {
            if (this.squares[i] != 0) continue;
            if (this.possiblesCount[i] < bestVal) {
                bestPos = i;
                bestCount = 0;
                bestVal = this.possiblesCount[i];
                continue;
            }
            if (this.possiblesCount[i] != bestVal) continue;
            ++bestCount;
        }
        if (bestVal == 10) {
            return 0;
        }
        if (bestVal == 0) {
            return 1;
        }
        return 2;
    }

    public boolean isLocked(int i) {
        return this._locked[i];
    }

    public int hintValue(int i) {
        return this._hintValue[i];
    }
}

