/*
 * Decompiled with CFR 0.152.
 */
package us.almy.mine;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import us.almy.mine.MinefieldModel;
import us.almy.mine.MinefieldView;

public class MinefieldTest
extends Frame {
    Label bombcount;
    BorderLayout borderLayout1;
    CheckboxMenuItem checkboxMenuItemOps;
    CheckboxMenuItem checkboxMenuItemQuickStart;
    Button clearButton;
    Button deduceButton;
    FlowLayout flowLayout1;
    GridLayout gridLayout1;
    Label label1;
    Label label3;
    Button lazyButton;
    private MinefieldModel m;
    Button markButton;
    Menu menu1;
    Menu menu2;
    MenuBar menuBar1 = new MenuBar();
    MenuItem menuItemDifficult;
    MenuItem menuItemEasy;
    MenuItem menuItemLarge;
    MenuItem menuItemMedium;
    MenuItem menuItemModerate;
    MenuItem menuItemSmall;
    Label message;
    MinefieldView minefieldView1;
    Panel panel1;
    Panel panel2;
    Button restartButton;
    private int startBombs = 7;
    private int startHeight = 12;
    private int startWidth = 12;
    Label unmarkedCount;

    public MinefieldTest() {
        this.menu1 = new Menu();
        this.menu2 = new Menu();
        this.menuItemSmall = new MenuItem();
        this.menuItemMedium = new MenuItem();
        this.menuItemLarge = new MenuItem();
        this.panel1 = new Panel();
        this.borderLayout1 = new BorderLayout();
        this.gridLayout1 = new GridLayout();
        this.label1 = new Label();
        this.unmarkedCount = new Label();
        this.label3 = new Label();
        this.bombcount = new Label();
        this.panel2 = new Panel();
        this.flowLayout1 = new FlowLayout();
        this.message = new Label();
        this.restartButton = new Button();
        this.minefieldView1 = new MinefieldView();
        this.markButton = new Button();
        this.clearButton = new Button();
        this.deduceButton = new Button();
        this.lazyButton = new Button();
        this.menuItemEasy = new MenuItem();
        this.menuItemModerate = new MenuItem();
        this.menuItemDifficult = new MenuItem();
        this.checkboxMenuItemQuickStart = new CheckboxMenuItem();
        this.checkboxMenuItemOps = new CheckboxMenuItem();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void clearButton_actionPerformed(ActionEvent e) {
        if (this.m.firstOrderClear()) {
            this.refreshAll();
        }
    }

    void deduceButton_actionPerformed(ActionEvent e) {
        if (this.m.thirdOrderClear()) {
            this.refreshAll();
        }
    }

    void jbInit() throws Exception {
        this.setBackground(SystemColor.menu);
        this.setMenuBar(this.menuBar1);
        this.setTitle("Minefield Game");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MinefieldTest.this.this_windowClosing(e);
            }
        });
        this.setLayout(this.borderLayout1);
        this.menu1.setLabel("Size");
        this.menu2.setLabel("Difficulty");
        this.menuItemSmall.setEnabled(false);
        this.menuItemSmall.setLabel("Small");
        this.menuItemSmall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.menuItemSmall_actionPerformed(e);
            }
        });
        this.menuItemMedium.setLabel("Medium");
        this.menuItemMedium.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.menuItemMedium_actionPerformed(e);
            }
        });
        this.menuItemLarge.setLabel("Large");
        this.menuItemLarge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.menuItemLarge_actionPerformed(e);
            }
        });
        this.panel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setHgap(0);
        this.gridLayout1.setRows(4);
        this.label1.setAlignment(1);
        this.label1.setText("Bombs");
        this.unmarkedCount.setAlignment(1);
        this.unmarkedCount.setText("144");
        this.label3.setAlignment(1);
        this.label3.setText("Unmarked");
        this.bombcount.setAlignment(1);
        this.bombcount.setText("20");
        this.panel2.setLayout(this.flowLayout1);
        this.message.setText("Good Luck!");
        this.restartButton.setLabel("Restart");
        this.restartButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.restartButton_actionPerformed(e);
            }
        });
        this.markButton.setLabel("Mark");
        this.markButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.markButton_actionPerformed(e);
            }
        });
        this.clearButton.setLabel("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.clearButton_actionPerformed(e);
            }
        });
        this.deduceButton.setLabel("Deduce");
        this.deduceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.deduceButton_actionPerformed(e);
            }
        });
        this.lazyButton.setLabel("Lazy!");
        this.lazyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.lazyButton_actionPerformed(e);
            }
        });
        this.minefieldView1.setBackground(SystemColor.menu);
        this.minefieldView1.setBuffered(true);
        this.minefieldView1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MinefieldTest.this.minefieldView1_MouseClicked(e);
            }
        });
        this.menuItemEasy.setLabel("Easy");
        this.menuItemEasy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.menuItemEasy_actionPerformed(e);
            }
        });
        this.menuItemModerate.setLabel("Moderate");
        this.menuItemModerate.setEnabled(false);
        this.menuItemModerate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.menuItemModerate_actionPerformed(e);
            }
        });
        this.menuItemDifficult.setLabel("Difficult");
        this.menuItemDifficult.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinefieldTest.this.menuItemDifficult_actionPerformed(e);
            }
        });
        this.checkboxMenuItemQuickStart.setLabel("Quick Start");
        this.panel1.setBackground(SystemColor.menu);
        this.panel2.setBackground(SystemColor.menu);
        this.checkboxMenuItemOps.setLabel("Oops Mode");
        this.panel2.add((Component)this.message, null);
        this.panel2.add((Component)this.restartButton, null);
        this.panel2.add((Component)this.markButton, null);
        this.menuBar1.add(this.menu1);
        this.menuBar1.add(this.menu2);
        this.menu1.add(this.menuItemSmall);
        this.menu1.add(this.menuItemMedium);
        this.menu1.add(this.menuItemLarge);
        this.menu2.add(this.menuItemEasy);
        this.menu2.add(this.menuItemModerate);
        this.menu2.add(this.menuItemDifficult);
        this.menu2.addSeparator();
        this.menu2.add(this.checkboxMenuItemQuickStart);
        this.menu2.add(this.checkboxMenuItemOps);
        this.add((Component)this.panel1, "West");
        this.panel1.add((Component)this.label1, null);
        this.panel1.add((Component)this.bombcount, null);
        this.panel1.add((Component)this.label3, null);
        this.panel1.add((Component)this.unmarkedCount, null);
        this.add((Component)this.minefieldView1, "Center");
        this.add((Component)this.panel2, "South");
        this.panel2.add((Component)this.clearButton, null);
        this.panel2.add((Component)this.deduceButton, null);
        this.panel2.add((Component)this.lazyButton, null);
    }

    void lazyButton_actionPerformed(ActionEvent e) {
        int count = 100;
        while (count-- > 0) {
            boolean active = true;
            while (active) {
                active = false;
                if (this.m.secondOrderMark()) {
                    this.refreshAll();
                    this.minefieldView1.update(this.minefieldView1.getGraphics());
                    active = true;
                }
                if (this.m.thirdOrderClear()) {
                    System.out.println("M");
                    while (this.m.thirdOrderClear()) {
                        System.out.println("More!");
                    }
                    this.refreshAll();
                    this.minefieldView1.update(this.minefieldView1.getGraphics());
                    active = true;
                }
                if (this.m.firstOrderClear()) {
                    this.refreshAll();
                    this.minefieldView1.update(this.minefieldView1.getGraphics());
                    active = true;
                }
                if (!this.m.thirdOrderClear()) continue;
                System.out.println("C");
                while (this.m.thirdOrderClear()) {
                    System.out.println("More!");
                }
                this.refreshAll();
                this.minefieldView1.update(this.minefieldView1.getGraphics());
                active = true;
            }
            if (this.m.getCovered() != 0) {
                System.out.println("Failed");
            } else if (this.m.getBombsLeft() == 0) {
                System.out.println("Success");
            } else {
                System.out.println("LOSS??");
            }
            this.restartGame();
        }
    }

    public static void main(String[] args) {
        MinefieldTest minefield = new MinefieldTest();
        minefield.pack();
        minefield.restartGame();
        minefield.show();
    }

    void markButton_actionPerformed(ActionEvent e) {
        if (this.m.secondOrderMark()) {
            this.refreshAll();
        }
    }

    void menuItemDifficult_actionPerformed(ActionEvent e) {
        this.startBombs = 5;
        this.menuItemEasy.setEnabled(true);
        this.menuItemModerate.setEnabled(true);
        this.menuItemDifficult.setEnabled(false);
    }

    void menuItemEasy_actionPerformed(ActionEvent e) {
        this.startBombs = 14;
        this.menuItemEasy.setEnabled(false);
        this.menuItemModerate.setEnabled(true);
        this.menuItemDifficult.setEnabled(true);
    }

    void menuItemLarge_actionPerformed(ActionEvent e) {
        this.startWidth = 30;
        this.startHeight = 30;
        this.menuItemSmall.setEnabled(true);
        this.menuItemMedium.setEnabled(true);
        this.menuItemLarge.setEnabled(false);
        this.restartGame();
    }

    void menuItemMedium_actionPerformed(ActionEvent e) {
        this.startWidth = 20;
        this.startHeight = 20;
        this.menuItemSmall.setEnabled(true);
        this.menuItemMedium.setEnabled(false);
        this.menuItemLarge.setEnabled(true);
        this.restartGame();
    }

    void menuItemModerate_actionPerformed(ActionEvent e) {
        this.startBombs = 7;
        this.menuItemEasy.setEnabled(true);
        this.menuItemModerate.setEnabled(false);
        this.menuItemDifficult.setEnabled(true);
    }

    void menuItemSmall_actionPerformed(ActionEvent e) {
        this.startWidth = 12;
        this.startHeight = 12;
        this.menuItemSmall.setEnabled(false);
        this.menuItemMedium.setEnabled(true);
        this.menuItemLarge.setEnabled(true);
        this.restartGame();
    }

    void minefieldView1_MouseClicked(MouseEvent mouseEvent) {
        Point p = MinefieldView.convertCoordinates(mouseEvent.getPoint());
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.checkboxMenuItemOps.getState() ? this.m.opsClear(p.x, p.y) : this.m.clear(p.x, p.y)) {
                this.refreshAll();
            }
        } else if ((mouseEvent.getModifiers() & 4) != 0 && this.m.toggle(p.x, p.y)) {
            this.refreshAll();
        }
    }

    void refreshAll() {
        this.bombcount.setText(String.valueOf(this.m.getBombsLeft()));
        this.unmarkedCount.setText(String.valueOf(this.m.getCovered()));
        this.minefieldView1.updateChanges();
        if (this.m.getCovered() != 0) {
            this.message.setText("Good Luck!");
            this.markButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.deduceButton.setEnabled(true);
            this.lazyButton.setEnabled(true);
        } else {
            this.markButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.deduceButton.setEnabled(false);
            this.lazyButton.setEnabled(false);
            if (this.m.getBombsLeft() == 0) {
                this.message.setText("You WIN!");
            } else {
                this.message.setText("You LOSE!");
            }
        }
    }

    void restartButton_actionPerformed(ActionEvent e) {
        this.restartGame();
    }

    void restartGame() {
        this.m = new MinefieldModel(this.startWidth, this.startHeight, this.startWidth * this.startHeight / this.startBombs);
        this.minefieldView1.setModel(this.m);
        this.pack();
        if (this.checkboxMenuItemQuickStart.getState()) {
            this.m.quickStart();
        }
        this.refreshAll();
    }

    void this_windowClosing(WindowEvent e) {
        System.exit(0);
    }
}

