/*
 * Decompiled with CFR 0.152.
 */
package us.almy.jelbumpro;

import java.awt.Color;
import java.awt.Dimension;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import us.almy.jelbumpro.AWord;
import us.almy.jelbumpro.JelbumSolver;

public class JumbleWordPanel
extends JPanel {
    private final JelbumSolver solver = new JelbumSolver();
    private JTextField characterField;
    private JLabel errorLabel;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JTextField patternField;
    private JList<String> resultList;
    String pattern;
    AWord theWord;
    int selectCount;

    public JumbleWordPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.characterField = new JTextField();
        this.patternField = new JTextField();
        this.errorLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.resultList = new JList();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButton1.setText("jButton1");
        this.jButton2.setText("jButton2");
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setPreferredSize(new Dimension(240, 121));
        this.errorLabel.setText("Error Message");
        this.resultList.setEnabled(false);
        this.jScrollPane1.setViewportView(this.resultList);
        this.jLabel1.setText("First Word");
        this.jLabel2.setText("Characters");
        this.jLabel3.setText("Pattern");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.patternField, -2, 103, -2).addComponent(this.characterField, -2, 103, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.characterField, -2, -1, -2).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.patternField, -2, -1, -2).addComponent(this.jLabel3)).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -2, 62, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel).addContainerGap()));
    }

    public void clearPanel() {
        this.characterField.setText("");
        this.errorLabel.setText("");
        this.patternField.setText("");
        String[] strings = new String[]{};
        this.resultList.setListData((String[])strings);
        this.resultList.setEnabled(false);
    }

    public void setLabel(String s) {
        this.jLabel1.setText(s);
        this.solver.readWords();
    }

    public boolean verifyData() {
        this.theWord = this.solver.makeAWord(this.characterField.getText());
        if (this.theWord == null) {
            this.errorLabel.setText("characters must be only lowercase letters");
            return false;
        }
        this.pattern = this.patternField.getText();
        this.selectCount = 0;
        for (int i = 0; i < this.pattern.length(); ++i) {
            char ch = this.pattern.charAt(i);
            if (ch != 'o' && ch != '-') {
                this.errorLabel.setText("pattern must consist of only '-' and 'o' characters");
                return false;
            }
            if (ch != 'o') continue;
            ++this.selectCount;
        }
        if (this.pattern.length() != this.theWord.length) {
            this.errorLabel.setText("characters and pattern must be same length");
            return false;
        }
        this.errorLabel.setText("");
        return true;
    }

    public boolean process() {
        if (this.theWord.length == 0) {
            return true;
        }
        LinkedList<String> answerText = new LinkedList<String>();
        LinkedList<Integer> patternList = new LinkedList<Integer>();
        patternList.add(this.theWord.length);
        this.solver.solve("", patternList, this.theWord, answerText);
        Object[] answers = answerText.toArray();
        String[] ans = new String[answers.length];
        for (int i = 0; i < ans.length; ++i) {
            ans[i] = (String)answers[i];
        }
        this.resultList.setListData((String[])ans);
        this.resultList.setSelectedIndex(0);
        this.resultList.setEnabled(true);
        return answers.length > 0;
    }

    public String getSelectedSolution() {
        if (this.theWord.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String theResult = this.resultList.getSelectedValue();
        if (theResult == null) {
            return "";
        }
        for (int i = 0; i < theResult.length(); ++i) {
            if (this.pattern.charAt(i) != 'o') continue;
            sb.append(theResult.charAt(i));
        }
        return sb.toString();
    }
}

