/*
 * Decompiled with CFR 0.152.
 */
package us.almy.jelbumpro;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import us.almy.jelbumpro.AWord;

public class JelbumSolver {
    static AWord wordlist;

    public void solve(String leadingMatch, LinkedList<Integer> pattern, AWord target, LinkedList<String> answerText) {
        int size = pattern.removeFirst();
        if (pattern.isEmpty() && size == target.length) {
            AWord wlist = wordlist;
            while (wlist != null) {
                if (wlist.length == size && wlist.checksum == target.checksum && wlist.equalMap(target)) {
                    answerText.add(leadingMatch + wlist.text);
                }
                wlist = wlist.next;
            }
        } else if (pattern.isEmpty()) {
            AWord wlist = wordlist;
            while (wlist != null) {
                if (wlist.length == size && wlist.fitMap(target)) {
                    answerText.add(leadingMatch + wlist.text);
                }
                wlist = wlist.next;
            }
        } else {
            AWord wlist = wordlist;
            while (wlist != null) {
                if (wlist.length == size && wlist.fitMap(target)) {
                    AWord remainder = new AWord();
                    remainder.length = target.length - size;
                    for (int i = 0; i < 26; ++i) {
                        remainder.map[i] = (byte)(target.map[i] - wlist.map[i]);
                    }
                    remainder.checksum = target.checksum - wlist.checksum;
                    this.solve(leadingMatch + wlist.text + " ", new LinkedList<Integer>(pattern), remainder, answerText);
                }
                wlist = wlist.next;
            }
        }
    }

    public AWord makeAWord(String st) {
        AWord aWord = new AWord();
        aWord.length = st.length();
        for (int i = 0; i < aWord.length; ++i) {
            char ch = st.charAt(i);
            if (ch < 'a' || ch > 'z') {
                return null;
            }
            aWord.checksum += ch - 97;
            int n = ch - 97;
            aWord.map[n] = (byte)(aWord.map[n] + 1);
        }
        return aWord;
    }

    public boolean readWords() {
        if (wordlist != null) {
            return true;
        }
        int counter = 0;
        AWord lastWord = null;
        BufferedReader myReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/us/almy/jelbumpro/wordlist.txt")));
        try {
            String thisLine;
            while ((thisLine = myReader.readLine()) != null) {
                AWord aWord;
                if (thisLine.length() < 1 || thisLine.length() > 10 || (aWord = this.makeAWord(thisLine)) == null) continue;
                aWord.text = thisLine;
                if (wordlist == null) {
                    wordlist = aWord;
                } else {
                    lastWord.next = aWord;
                }
                lastWord = aWord;
                ++counter;
            }
            myReader.close();
        }
        catch (IOException io) {
            return false;
        }
        return true;
    }
}

