/*
 * Decompiled with CFR 0.152.
 */
package us.almy.jelbumpro;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import us.almy.jelbumpro.AWord;
import us.almy.jelbumpro.JelbumSolver;
import us.almy.jelbumpro.JumbleWordPanel;

public class JelbumPro
extends JFrame {
    JumbleWordPanel[] panels;
    final String[] panelNames = new String[]{"First Word", "Second Word", "Third Word", "Fourth Word", "Fifth Word", "Sixth Word"};
    LinkedList<Integer> finalPattern = new LinkedList();
    private JTextArea answerTextArea;
    private JButton clearButton;
    private JButton finalButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel jumbleText;
    private JumbleWordPanel jumbleWordPanel1;
    private JumbleWordPanel jumbleWordPanel2;
    private JumbleWordPanel jumbleWordPanel3;
    private JumbleWordPanel jumbleWordPanel4;
    private JumbleWordPanel jumbleWordPanel5;
    private JumbleWordPanel jumbleWordPanel6;
    private JTextField patternField;
    private JButton solveButton;

    public JelbumPro() {
        this.initComponents();
        this.panels = new JumbleWordPanel[]{this.jumbleWordPanel2, this.jumbleWordPanel3, this.jumbleWordPanel1, this.jumbleWordPanel6, this.jumbleWordPanel4, this.jumbleWordPanel5};
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i].setLabel(this.panelNames[i]);
        }
    }

    private void initComponents() {
        this.jumbleWordPanel2 = new JumbleWordPanel();
        this.jumbleWordPanel1 = new JumbleWordPanel();
        this.jumbleWordPanel4 = new JumbleWordPanel();
        this.jumbleWordPanel3 = new JumbleWordPanel();
        this.jumbleWordPanel6 = new JumbleWordPanel();
        this.jumbleWordPanel5 = new JumbleWordPanel();
        this.patternField = new JTextField();
        this.solveButton = new JButton();
        this.finalButton = new JButton();
        this.clearButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.answerTextArea = new JTextArea();
        this.jumbleText = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Jelbum Pro");
        this.solveButton.setText("Solve Words");
        this.solveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JelbumPro.this.solveButtonActionPerformed(evt);
            }
        });
        this.finalButton.setText("Solve");
        this.finalButton.setEnabled(false);
        this.finalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JelbumPro.this.finalButtonActionPerformed(evt);
            }
        });
        this.clearButton.setText("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JelbumPro.this.clearButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Pattern");
        this.answerTextArea.setEditable(false);
        this.answerTextArea.setColumns(20);
        this.answerTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.answerTextArea);
        this.jumbleText.setText("????");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jumbleWordPanel4, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jumbleWordPanel1, GroupLayout.Alignment.LEADING, -1, 358, Short.MAX_VALUE)).addComponent(this.jumbleText, -2, 216, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.patternField, -2, 141, -2)).addComponent(this.jScrollPane1, -2, 254, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jumbleWordPanel5, -1, -1, Short.MAX_VALUE).addComponent(this.jumbleWordPanel6, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.finalButton).addComponent(this.solveButton).addComponent(this.jumbleWordPanel3, -2, 358, -2).addComponent(this.clearButton)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jumbleWordPanel2, -2, 357, -2).addContainerGap(370, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jumbleWordPanel3, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jumbleWordPanel1, -2, -1, -2).addComponent(this.jumbleWordPanel6, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jumbleWordPanel4, -2, -1, -2).addComponent(this.jumbleWordPanel5, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.patternField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jumbleText)).addComponent(this.solveButton)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 100, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.finalButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clearButton).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(16, 16, 16).addComponent(this.jumbleWordPanel2, -2, -1, -2).addContainerGap(474, Short.MAX_VALUE))));
        this.pack();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        for (JumbleWordPanel panel : this.panels) {
            panel.clearPanel();
        }
        this.patternField.setText("");
        this.answerTextArea.setText("");
        this.finalButton.setEnabled(false);
    }

    private void solveButtonActionPerformed(ActionEvent evt) {
        boolean verified = true;
        int selectedCharacters = 0;
        for (JumbleWordPanel panel : this.panels) {
            verified &= panel.verifyData();
            selectedCharacters += panel.selectCount;
        }
        if (!verified) {
            return;
        }
        this.finalPattern.clear();
        int count = 0;
        int patternLength = 0;
        String rawPattern = this.patternField.getText();
        for (int i = rawPattern.length() - 1; i >= 0; --i) {
            boolean c;
            boolean bl = c = rawPattern.charAt(i) != ' ';
            if (c) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            this.finalPattern.addFirst(count);
            patternLength += count;
            count = 0;
        }
        if (count > 0) {
            this.finalPattern.addFirst(count);
            patternLength += count;
        }
        if (patternLength != selectedCharacters) {
            this.answerTextArea.setText("pattern length must match selected characters");
            return;
        }
        this.answerTextArea.setText("");
        boolean solved = true;
        for (JumbleWordPanel panel : this.panels) {
            solved &= panel.process();
        }
        if (solved) {
            this.finalButton.setEnabled(true);
        }
    }

    private void finalButtonActionPerformed(ActionEvent evt) {
        JelbumSolver solver = new JelbumSolver();
        solver.readWords();
        StringBuilder sb = new StringBuilder();
        LinkedList<String> answerText = new LinkedList<String>();
        for (JumbleWordPanel panel : this.panels) {
            sb.append(panel.getSelectedSolution());
        }
        AWord finalWord = solver.makeAWord(sb.toString());
        this.jumbleText.setText(sb.toString());
        solver.solve("", this.finalPattern, finalWord, answerText);
        if (answerText.isEmpty()) {
            this.answerTextArea.setText("NO SOLUTION FOUND");
        } else {
            Iterator it = answerText.iterator();
            while (it.hasNext()) {
                this.answerTextArea.append((String)it.next() + "\n");
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JelbumPro().setVisible(true);
            }
        });
    }
}

