/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package almy;

import javax.swing.UIManager;

/**
 *
 * @author tom
 */
public class DecoderSolver extends javax.swing.JFrame {

    /**
     * Creates new form NewJFrame
     */
    public DecoderSolver() {
        initComponents();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane2 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextField1 = new javax.swing.JTextArea();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTextField2 = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jLabelUnassigned = new javax.swing.JLabel();
        jLabelMultiple = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("DECODER");

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"A", null, ""},
                {"B", null, ""},
                {"C", null, ""},
                {"D", null, ""},
                {"E", null, ""},
                {"F", null, ""},
                {"G", null, ""},
                {"H", null, ""},
                {"I", null, ""},
                {"J", null, ""},
                {"K", null, ""},
                {"L", null, ""},
                {"M", null, ""},
                {"N", null, ""},
                {"O", null, ""},
                {"P", null, ""},
                {"Q", null, ""},
                {"R", null, ""},
                {"S", null, ""},
                {"T", null, ""},
                {"U", null, ""},
                {"V", null, ""},
                {"W", null, ""},
                {"X", null, ""},
                {"Y", null, ""},
                {"Z", null, ""}
            },
            new String [] {
                "Letter", "Count", "BindTo"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.Integer.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, true
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTable1.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                jTable1PropertyChange(evt);
            }
        });
        jScrollPane2.setViewportView(jTable1);

        jButton1.setText("Process");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("Reset");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jTextField1.setColumns(20);
        jTextField1.setRows(5);
        jTextField1.setName(""); // NOI18N
        jScrollPane1.setViewportView(jTextField1);

        jTextField2.setColumns(20);
        jTextField2.setRows(5);
        jScrollPane3.setViewportView(jTextField2);

        jLabel1.setText("Most frequent: ETAOIN SRHLDC ");

        jLabelUnassigned.setText("Unassigned: ABCDEFGHIJKLMNOPQRSTUVWXYZ");

        jLabelMultiple.setText("Multiple Assigned (BAD):");

        jLabel2.setText("Input text in lowercase");

        jLabel3.setText("Output text, untranslated appears in capitals");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addContainerGap()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                            .addComponent(jButton1)
                                            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 377, Short.MAX_VALUE)
                                            .addComponent(jScrollPane3)))
                                    .addComponent(jButton2)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(25, 25, 25)
                                        .addComponent(jLabel1)))
                                .addGap(0, 0, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(25, 25, 25)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(jLabel3)
                                        .addGap(0, 0, Short.MAX_VALUE))
                                    .addComponent(jLabelMultiple, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(jLabelUnassigned, javax.swing.GroupLayout.DEFAULT_SIZE, 358, Short.MAX_VALUE))))
                        .addGap(18, 18, 18))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(24, 24, 24)
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 236, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabelUnassigned)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabelMultiple)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jScrollPane3, javax.swing.GroupLayout.PREFERRED_SIZE, 111, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jButton2))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 439, Short.MAX_VALUE))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        updateTable();
        updateText();
        updateTally();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jTable1PropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_jTable1PropertyChange
        updateText();
        updateTally();
    }//GEN-LAST:event_jTable1PropertyChange

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed

        for (int i = 0; i < 26; i++) {
            jTable1.getModel().setValueAt(0, i, 1);
            jTable1.getModel().setValueAt("", i, 2);
       }
       jTextField1.setText("");
       jTextField2.setText("");
       updateTally();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void updateTable() {
        String fromText = jTextField1.getText().toUpperCase();
        for (int i = 0; i < 26; i++)
            jTable1.getModel().setValueAt(0, i, 1);
        for (char ch:fromText.toCharArray() ) {
            if (Character.isLetter(ch))
            {
                int i = ch - 'A';
                jTable1.getModel().setValueAt(1 + (Integer)(jTable1.getModel().getValueAt(i, 1)), i, 1);
            } 
        }
    }

    private void updateText() {
        String fromText = jTextField1.getText().toUpperCase();
        StringBuilder toText = new StringBuilder();
        for (char ch:fromText.toCharArray() ) {
            if (Character.isLetter(ch))
            {
                String convertedChar = (String)(jTable1.getModel().getValueAt(ch-'A',2));
                final int convertedCharLength = convertedChar.length();
                if (convertedCharLength == 0) {
                    /* empty, so just pass through original character, which will be uppercase */
                    toText.append(ch);
                } else {
                    /* If there is more than one character to be substituted, take the last one */
                    if (convertedCharLength > 1) {
                        convertedChar = convertedChar.substring(convertedCharLength-1);
                        jTable1.getModel().setValueAt(convertedChar, ch-'A',2);
                    }
                    /* Check is substitued value is a valid single character, if not, remove character from table */
                    if (Character.isLetter(convertedChar.charAt(0))) { 
                        toText.append(convertedChar.substring(0,1));
                    } else {
                        jTable1.getModel().setValueAt("", ch-'A', 2);
                    }
                }
            } else {
                /* Not a character to translate, so just pass it to output string */
                toText.append(ch);
            }
        }
        jTextField2.setText(toText.toString());
    }

    private void updateTally() {
        StringBuilder unassigned = new StringBuilder("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        StringBuilder multiple = new StringBuilder();
        for (int i = 0; i < 26; i++) {
            String st = ((String)jTable1.getModel().getValueAt(i,2)).toUpperCase();
            if (!st.isEmpty() && Character.isLetter(st.charAt(0))) {
                if (unassigned.toString().contains(st)) {
                    /* Good -- it was unassigned */
                    unassigned.deleteCharAt(unassigned.indexOf(st));
                } else {
                    multiple.append(st);
                }
            }
        }
        jLabelMultiple.setText("Multiple Assigned (BAD): " + multiple);
        jLabelUnassigned.setText("Unassigned: " + unassigned);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
            try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception ex) {
        }
        ;

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new DecoderSolver().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabelMultiple;
    private javax.swing.JLabel jLabelUnassigned;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTable jTable1;
    private javax.swing.JTextArea jTextField1;
    private javax.swing.JTextArea jTextField2;
    // End of variables declaration//GEN-END:variables
}
