/*
 * Decompiled with CFR 0.152.
 */
package almy;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class DecoderSolver
extends JFrame {
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelMultiple;
    private JLabel jLabelUnassigned;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTable jTable1;
    private JTextArea jTextField1;
    private JTextArea jTextField2;

    public DecoderSolver() {
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextField1 = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.jTextField2 = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jLabelUnassigned = new JLabel();
        this.jLabelMultiple = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("DECODER");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{"A", null, ""}, {"B", null, ""}, {"C", null, ""}, {"D", null, ""}, {"E", null, ""}, {"F", null, ""}, {"G", null, ""}, {"H", null, ""}, {"I", null, ""}, {"J", null, ""}, {"K", null, ""}, {"L", null, ""}, {"M", null, ""}, {"N", null, ""}, {"O", null, ""}, {"P", null, ""}, {"Q", null, ""}, {"R", null, ""}, {"S", null, ""}, {"T", null, ""}, {"U", null, ""}, {"V", null, ""}, {"W", null, ""}, {"X", null, ""}, {"Y", null, ""}, {"Z", null, ""}}, new String[]{"Letter", "Count", "BindTo"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Integer.class, String.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DecoderSolver.this.jTable1PropertyChange(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        this.jButton1.setText("Process");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DecoderSolver.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Reset");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DecoderSolver.this.jButton2ActionPerformed(evt);
            }
        });
        this.jTextField1.setColumns(20);
        this.jTextField1.setRows(5);
        this.jTextField1.setName("");
        this.jScrollPane1.setViewportView(this.jTextField1);
        this.jTextField2.setColumns(20);
        this.jTextField2.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextField2);
        this.jLabel1.setText("Most frequent: ETAOIN SRHLDC ");
        this.jLabelUnassigned.setText("Unassigned: ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        this.jLabelMultiple.setText("Multiple Assigned (BAD):");
        this.jLabel2.setText("Input text in lowercase");
        this.jLabel3.setText("Output text, untranslated appears in capitals");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1).addComponent(this.jScrollPane1, -1, 377, Short.MAX_VALUE).addComponent(this.jScrollPane3))).addComponent(this.jButton2).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.jLabel1))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jLabelMultiple, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelUnassigned, -1, 358, Short.MAX_VALUE)))).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE))).addComponent(this.jScrollPane2, -2, 236, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelUnassigned).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMultiple).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)).addComponent(this.jScrollPane2, -1, 439, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.updateTable();
        this.updateText();
        this.updateTally();
    }

    private void jTable1PropertyChange(PropertyChangeEvent evt) {
        this.updateText();
        this.updateTally();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 26; ++i) {
            this.jTable1.getModel().setValueAt(0, i, 1);
            this.jTable1.getModel().setValueAt("", i, 2);
        }
        this.jTextField1.setText("");
        this.jTextField2.setText("");
        this.updateTally();
    }

    private void updateTable() {
        String fromText = this.jTextField1.getText().toUpperCase();
        for (int i = 0; i < 26; ++i) {
            this.jTable1.getModel().setValueAt(0, i, 1);
        }
        for (char ch : fromText.toCharArray()) {
            if (!Character.isLetter(ch)) continue;
            int i = ch - 65;
            this.jTable1.getModel().setValueAt(1 + (Integer)this.jTable1.getModel().getValueAt(i, 1), i, 1);
        }
    }

    private void updateText() {
        String fromText = this.jTextField1.getText().toUpperCase();
        StringBuilder toText = new StringBuilder();
        for (char ch : fromText.toCharArray()) {
            if (Character.isLetter(ch)) {
                String convertedChar = (String)this.jTable1.getModel().getValueAt(ch - 65, 2);
                int convertedCharLength = convertedChar.length();
                if (convertedCharLength == 0) {
                    toText.append(ch);
                    continue;
                }
                if (convertedCharLength > 1) {
                    convertedChar = convertedChar.substring(convertedCharLength - 1);
                    this.jTable1.getModel().setValueAt(convertedChar, ch - 65, 2);
                }
                if (Character.isLetter(convertedChar.charAt(0))) {
                    toText.append(convertedChar.substring(0, 1));
                    continue;
                }
                this.jTable1.getModel().setValueAt("", ch - 65, 2);
                continue;
            }
            toText.append(ch);
        }
        this.jTextField2.setText(toText.toString());
    }

    private void updateTally() {
        StringBuilder unassigned = new StringBuilder("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        StringBuilder multiple = new StringBuilder();
        for (int i = 0; i < 26; ++i) {
            String st = ((String)this.jTable1.getModel().getValueAt(i, 2)).toUpperCase();
            if (st.isEmpty() || !Character.isLetter(st.charAt(0))) continue;
            if (unassigned.toString().contains(st)) {
                unassigned.deleteCharAt(unassigned.indexOf(st));
                continue;
            }
            multiple.append(st);
        }
        this.jLabelMultiple.setText("Multiple Assigned (BAD): " + multiple);
        this.jLabelUnassigned.setText("Unassigned: " + unassigned);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DecoderSolver().setVisible(true);
            }
        });
    }
}

