\ FORTH SCREEN FILE  LIST PROGRAM
\ COPYRIGHT (C) 1985 BY THOMAS ALMY
\ ALL RIGHTS RESERVED.

\  Users of ForthCMP are given permission to use or distribute this
\  program, as long as no charge is made and the credit message is maintained.

100 MSDOS
SCONSTANT SDEFSTR SCR" \ SOURCE DEFAULTS TO .SCR 
SCONSTANT DDEFSTR LST" \ DESTINATION  DEFAULTS TO .LST 
HEX 
6000 CONSTANT BUFSIZ   \ each i/o buffer is to be LARGE!
DECIMAL
INCLUDE FILTER

1 0 IN/OUT
: .COUNTED-LINE  ( line# - )
  CR 2 .R  2 SPACES  HERE 64 -TRAILING TYPE ;

1 1 IN/OUT
: LIST ( SCREEN# - VALID )
  HERE 64 EXPECT  
  SPAN @ 0> IF ( got one )
	." Screen " .  CR
	15 0 DO I .COUNTED-LINE  HERE  64 EXPECT LOOP
	15 .COUNTED-LINE 
	CR CR CR   1  
  ELSE ( done )
	DROP 0 
  THEN ; 

0 0 IN/OUT 
: NOTICE  
	." FORTH SCREEN LISTING PROGRAM " CR
	." COPYRIGHT (C) 1985 BY THOMAS ALMY " CR 
  ;

0 0 IN/OUT 
: USAGE   
    CONSOLE CR
    ." USAGE:  LIST  [SCRFILE] [LISTFILE]" CR
    ." where SCRFILE is a file of Forth screens (default extension SCR)" CR
    ." and LISTFILE is file for listing (default extension LST)" CR
    ." If SCRFILE is not specified, standard input is used," CR
    ." use `-' if listfile is to be specified." CR
    ABORT
  ;

: MAIN    
        SETBUFS ( which allows I/O )
	NOTICE  ( Welcome message )
	SETFILES IF USAGE THEN ( open files, if possible )
	OPTIONSTRING 2+ @ IF USAGE THEN ( any arg means bad syntax )
	0 
	BEGIN 
		DUP LIST 
	WHILE
		1+ DUP 3 MOD 0= IF CR CR CR CR CR CR THEN 
	REPEAT
	DROP 
	BYE 
  ;

INCLUDE DOS2
INCLUDE FORTHLIB
END

